{*******************************************************}
{               RichEdit Syntax HighLight               }
{                     version 3.0                       }
{ Author:                                               }
{ Serhiy Perevoznyk                                     }
{ serge_perevoznyk@hotmail.com                          }
{                                                       }
{*******************************************************}

{The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in compliance
with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is: SynHighlighterJScript.pas, released 2000-04-14.
The Original Code is based on the mwJScript.pas file from the
mwEdit component suite by Martin Waldenburg and other developers, the Initial
Author of this file is Tony de Buys.
All Rights Reserved.
The Original Code can be obtained from http://synedit.sourceforge.net/
}

unit psvJScript;


interface

uses
  SysUtils, 
  Windows, 
  Messages, 
  Classes, 
  Controls, 
  Graphics, 
  psvRichSyntax;

type
  TtkTokenKind = (tkComment, tkIdentifier, tkKey, tkNull, tkNumber, tkSpace,
    tkString, tkSymbol, tkUnknown);

  TRangeState = (rsUnknown, rsANSI);

  TProcTableProc = procedure of object;

  PIdentFuncTableFunc = ^TIdentFuncTableFunc;
  TIdentFuncTableFunc = function: TtkTokenKind of object;

type
  TpsvJScriptRTF = class(TpsvRTFSyntax)
  private
    fRange: TRangeState;
    fLine: PChar;
    fLineNumber: Integer;
    fProcTable: array[#0..#255] of TProcTableProc;
    Run: LongInt;
    fStringLen: Integer;
    fToIdent: PChar;
    fTokenPos: Integer;
    FTokenID: TtkTokenKind;
    fIdentFuncTable: array[0..252] of TIdentFuncTableFunc;
    function KeyHash(ToHash: PChar): Integer;
    function KeyComp(const aKey: String): Boolean;
    function Func5: TtkTokenKind;
    function Func15: TtkTokenKind;
    function Func17: TtkTokenKind;
    function Func18: TtkTokenKind;
    function Func22: TtkTokenKind;
    function Func23: TtkTokenKind;
    function Func25: TtkTokenKind;
    function Func26: TtkTokenKind;
    function Func29: TtkTokenKind;
    function Func30: TtkTokenKind;
    function Func33: TtkTokenKind;
    function Func34: TtkTokenKind;
    function Func35: TtkTokenKind;
    function Func36: TtkTokenKind;
    function Func37: TtkTokenKind;
    function Func38: TtkTokenKind;
    function Func39: TtkTokenKind;
    function Func40: TtkTokenKind;
    function Func41: TtkTokenKind;
    function Func42: TtkTokenKind;
    function Func43: TtkTokenKind;
    function Func44: TtkTokenKind;
    function Func45: TtkTokenKind;
    function Func46: TtkTokenKind;
    function Func47: TtkTokenKind;
    function Func48: TtkTokenKind;
    function Func49: TtkTokenKind;
    function Func50: TtkTokenKind;
    function Func51: TtkTokenKind;
    function Func52: TtkTokenKind;
    function Func53: TtkTokenKind;
    function Func54: TtkTokenKind;
    function Func55: TtkTokenKind;
    function Func56: TtkTokenKind;
    function Func57: TtkTokenKind;
    function Func58: TtkTokenKind;
    function Func59: TtkTokenKind;
    function Func60: TtkTokenKind;
    function Func61: TtkTokenKind;
    function Func62: TtkTokenKind;
    function Func63: TtkTokenKind;
    function Func64: TtkTokenKind;
    function Func65: TtkTokenKind;
    function Func66: TtkTokenKind;
    function Func67: TtkTokenKind;
    function Func69: TtkTokenKind;
    function Func70: TtkTokenKind;
    function Func71: TtkTokenKind;
    function Func72: TtkTokenKind;
    function Func73: TtkTokenKind;
    function Func74: TtkTokenKind;
    function Func75: TtkTokenKind;
    function Func76: TtkTokenKind;
    function Func77: TtkTokenKind;
    function Func78: TtkTokenKind;
    function Func79: TtkTokenKind;
    function Func81: TtkTokenKind;
    function Func82: TtkTokenKind;
    function Func83: TtkTokenKind;
    function Func84: TtkTokenKind;
    function Func85: TtkTokenKind;
    function Func87: TtkTokenKind;
    function Func88: TtkTokenKind;
    function Func89: TtkTokenKind;
    function Func90: TtkTokenKind;
    function Func91: TtkTokenKind;
    function Func92: TtkTokenKind;
    function Func93: TtkTokenKind;
    function Func94: TtkTokenKind;
    function Func95: TtkTokenKind;
    function Func96: TtkTokenKind;
    function Func98: TtkTokenKind;
    function Func99: TtkTokenKind;
    function Func100: TtkTokenKind;
    function Func101: TtkTokenKind;
    function Func102: TtkTokenKind;
    function Func103: TtkTokenKind;
    function Func105: TtkTokenKind;
    function Func106: TtkTokenKind;
    function Func107: TtkTokenKind;
    function Func108: TtkTokenKind;
    function Func109: TtkTokenKind;
    function Func110: TtkTokenKind;
    function Func111: TtkTokenKind;
    function Func113: TtkTokenKind;
    function Func114: TtkTokenKind;
    function Func115: TtkTokenKind;
    function Func117: TtkTokenKind;
    function Func118: TtkTokenKind;
    function Func122: TtkTokenKind;
    function Func123: TtkTokenKind;
    function Func125: TtkTokenKind;
    function Func128: TtkTokenKind;
    function Func129: TtkTokenKind;
    function Func130: TtkTokenKind;
    function Func131: TtkTokenKind;
    function Func132: TtkTokenKind;
    function Func133: TtkTokenKind;
    function Func135: TtkTokenKind;
    function Func136: TtkTokenKind;
    function Func139: TtkTokenKind;
    function Func142: TtkTokenKind;
    function Func145: TtkTokenKind;
    function Func147: TtkTokenKind;
    function Func150: TtkTokenKind;
    function Func158: TtkTokenKind;
    function Func162: TtkTokenKind;
    function Func166: TtkTokenKind;
    function Func169: TtkTokenKind;
    function Func170: TtkTokenKind;
    function Func210: TtkTokenKind;
    function Func220: TtkTokenKind;
    function Func252: TtkTokenKind;
    procedure AndSymbolProc;
    procedure AsciiCharProc;
    procedure CommentProc;                                                      //mh 2000-07-14
    procedure CRProc;
    procedure IdentProc;
    procedure IntegerProc;
    procedure LFProc;
    procedure MinusProc;
    procedure ModSymbolProc;
    procedure NullProc;
    procedure NumberProc;
    procedure OrSymbolProc;
    procedure PlusProc;
    procedure PointProc;
    procedure SlashProc;
    procedure SpaceProc;
    procedure StarProc;
    procedure StringProc;
    procedure SymbolProc;
    procedure UnknownProc;
    function AltFunc: TtkTokenKind;
    procedure InitIdent;
    function IdentKind(MayBe: PChar): TtkTokenKind;
    procedure MakeMethodTables;
  protected
    function GetEOL: Boolean; override;
    function GetRange: Pointer; 
    function GetTokenID: TtkTokenKind;
    procedure SetLine(NewValue: String; LineNumber: Integer); override;
    function GetToken: String; override;
    function GetTokenAttribute: integer; override;
    function GetTokenKind: integer; 
    function GetTokenPos: Integer; 
    procedure Next; override;
    procedure SetRange(Value: Pointer); 
    procedure ReSetRange; 
    procedure PrepareToken(var AToken : string); override;
  public
    constructor Create; override;
    procedure SetupDefaultColors; override;
  end;

implementation

var
  Identifiers: array[#0..#255] of ByteBool;
  mHashTable: array[#0..#255] of Integer;

procedure MakeIdentTable;
var
  I, J: Char;
begin
  for I := #0 to #255 do
  begin
    Case I of
      '_', '0'..'9', 'a'..'z', 'A'..'Z': Identifiers[I] := True;
      else Identifiers[I] := False;
    end;
    J := UpCase(I);
    Case I in ['_', 'A'..'Z', 'a'..'z'] of
      True: mHashTable[I] := Ord(J) - 64
      else mHashTable[I] := 0;
    end;
  end;
end;

procedure TpsvJScriptRTF.InitIdent;
var
  I: Integer;
  pF: PIdentFuncTableFunc;
begin
  pF := PIdentFuncTableFunc(@fIdentFuncTable);
  for I := Low(fIdentFuncTable) to High(fIdentFuncTable) do begin
    pF^ := AltFunc;
    Inc(pF);
  end;
  fIdentFuncTable[5] := Func5;
  fIdentFuncTable[15] := Func15;
  fIdentFuncTable[17] := Func17;
  fIdentFuncTable[18] := Func18;
  fIdentFuncTable[22] := Func22;
  fIdentFuncTable[23] := Func23;
  fIdentFuncTable[25] := Func25;
  fIdentFuncTable[26] := Func26;
  fIdentFuncTable[29] := Func29;
  fIdentFuncTable[30] := Func30;
  fIdentFuncTable[33] := Func33;
  fIdentFuncTable[34] := Func34;
  fIdentFuncTable[35] := Func35;
  fIdentFuncTable[36] := Func36;
  fIdentFuncTable[37] := Func37;
  fIdentFuncTable[38] := Func38;
  fIdentFuncTable[39] := Func39;
  fIdentFuncTable[40] := Func40;
  fIdentFuncTable[41] := Func41;
  fIdentFuncTable[42] := Func42;
  fIdentFuncTable[43] := Func43;
  fIdentFuncTable[44] := Func44;
  fIdentFuncTable[45] := Func45;
  fIdentFuncTable[46] := Func46;
  fIdentFuncTable[47] := Func47;
  fIdentFuncTable[48] := Func48;
  fIdentFuncTable[49] := Func49;
  fIdentFuncTable[50] := Func50;
  fIdentFuncTable[51] := Func51;
  fIdentFuncTable[52] := Func52;
  fIdentFuncTable[53] := Func53;
  fIdentFuncTable[54] := Func54;
  fIdentFuncTable[55] := Func55;
  fIdentFuncTable[56] := Func56;
  fIdentFuncTable[57] := Func57;
  fIdentFuncTable[58] := Func58;
  fIdentFuncTable[59] := Func59;
  fIdentFuncTable[60] := Func60;
  fIdentFuncTable[61] := Func61;
  fIdentFuncTable[62] := Func62;
  fIdentFuncTable[63] := Func63;
  fIdentFuncTable[64] := Func64;
  fIdentFuncTable[65] := Func65;
  fIdentFuncTable[66] := Func66;
  fIdentFuncTable[67] := Func67;
  fIdentFuncTable[69] := Func69;
  fIdentFuncTable[70] := Func70;
  fIdentFuncTable[71] := Func71;
  fIdentFuncTable[72] := Func72;
  fIdentFuncTable[73] := Func73;
  fIdentFuncTable[74] := Func74;
  fIdentFuncTable[75] := Func75;
  fIdentFuncTable[76] := Func76;
  fIdentFuncTable[77] := Func77;
  fIdentFuncTable[78] := Func78;
  fIdentFuncTable[79] := Func79;
  fIdentFuncTable[81] := Func81;
  fIdentFuncTable[82] := Func82;
  fIdentFuncTable[83] := Func83;
  fIdentFuncTable[84] := Func84;
  fIdentFuncTable[85] := Func85;
  fIdentFuncTable[87] := Func87;
  fIdentFuncTable[88] := Func88;
  fIdentFuncTable[89] := Func89;
  fIdentFuncTable[90] := Func90;
  fIdentFuncTable[91] := Func91;
  fIdentFuncTable[92] := Func92;
  fIdentFuncTable[93] := Func93;
  fIdentFuncTable[94] := Func94;
  fIdentFuncTable[95] := Func95;
  fIdentFuncTable[96] := Func96;
  fIdentFuncTable[98] := Func98;
  fIdentFuncTable[99] := Func99;
  fIdentFuncTable[100] := Func100;
  fIdentFuncTable[101] := Func101;
  fIdentFuncTable[102] := Func102;
  fIdentFuncTable[103] := Func103;
  fIdentFuncTable[105] := Func105;
  fIdentFuncTable[106] := Func106;
  fIdentFuncTable[107] := Func107;
  fIdentFuncTable[108] := Func108;
  fIdentFuncTable[109] := Func109;
  fIdentFuncTable[110] := Func110;
  fIdentFuncTable[111] := Func111;
  fIdentFuncTable[113] := Func113;
  fIdentFuncTable[114] := Func114;
  fIdentFuncTable[115] := Func115;
  fIdentFuncTable[117] := Func117;
  fIdentFuncTable[118] := Func118;
  fIdentFuncTable[122] := Func122;
  fIdentFuncTable[123] := Func123;
  fIdentFuncTable[125] := Func125;
  fIdentFuncTable[128] := Func128;
  fIdentFuncTable[129] := Func129;
  fIdentFuncTable[130] := Func130;
  fIdentFuncTable[131] := Func131;
  fIdentFuncTable[132] := Func132;
  fIdentFuncTable[133] := Func133;
  fIdentFuncTable[135] := Func135;
  fIdentFuncTable[136] := Func136;
  fIdentFuncTable[139] := Func139;
  fIdentFuncTable[142] := Func142;
  fIdentFuncTable[145] := Func145;
  fIdentFuncTable[147] := Func147;
  fIdentFuncTable[150] := Func150;
  fIdentFuncTable[158] := Func158;
  fIdentFuncTable[162] := Func162;
  fIdentFuncTable[166] := Func166;
  fIdentFuncTable[169] := Func169;
  fIdentFuncTable[170] := Func170;
  fIdentFuncTable[210] := Func210;
  fIdentFuncTable[220] := Func220;
  fIdentFuncTable[252] := Func252;
end;

function TpsvJScriptRTF.KeyHash(ToHash: PChar): Integer;
begin
  Result := 0;
  while ToHash^ in ['_', '0'..'9', 'a'..'z', 'A'..'Z'] do
  begin
    inc(Result, mHashTable[ToHash^]);
    inc(ToHash);
  end;
  fStringLen := ToHash - fToIdent;
end;

function TpsvJScriptRTF.KeyComp(const aKey: String): Boolean;
var
  I: Integer;
  Temp: PChar;
begin
  Temp := fToIdent;
  if Length(aKey) = fStringLen then
  begin
    Result := True;
    for i := 1 to fStringLen do
    begin
      if mHashTable[Temp^] <> mHashTable[aKey[i]] then
      begin
        Result := False;
        break;
      end;
      inc(Temp);
    end;
  end else Result := False;
end;

function TpsvJScriptRTF.Func5: TtkTokenKind;
begin
  if KeyComp('E') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func15: TtkTokenKind;
begin
  if KeyComp('if') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func17: TtkTokenKind;
begin
  if KeyComp('back') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func18: TtkTokenKind;
begin
  if KeyComp('big') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func22: TtkTokenKind;
begin
  if KeyComp('abs') then Result := tkKey else
    if KeyComp('go') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func23: TtkTokenKind;
begin
  if KeyComp('in') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func25: TtkTokenKind;
begin
  if KeyComp('Area') then Result := tkKey else
    if KeyComp('PI') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func26: TtkTokenKind;
begin
  if KeyComp('LN10') then Result := tkKey else
    if KeyComp('LN2') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func29: TtkTokenKind;
begin
  if KeyComp('NaN') then Result := tkKey else
    if KeyComp('ceil') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func30: TtkTokenKind;
begin
  if KeyComp('Date') then Result := tkKey else
    if KeyComp('Date') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func33: TtkTokenKind;
begin
  if KeyComp('bold') then Result := tkKey else
    if KeyComp('name') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func34: TtkTokenKind;
begin
  if KeyComp('log') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func35: TtkTokenKind;
begin
  if KeyComp('Image') then Result := tkKey else
    if KeyComp('tan') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func36: TtkTokenKind;
begin
  if KeyComp('min') then Result := tkKey else
    if KeyComp('hash') then Result := tkKey else
      if KeyComp('atan2') then Result := tkKey else
        if KeyComp('atan') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func37: TtkTokenKind;
begin
  if KeyComp('break') then Result := tkKey else
    if KeyComp('href') then Result := tkKey else
      if KeyComp('cos') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func38: TtkTokenKind;
begin
  if KeyComp('click') then Result := tkKey else
    if KeyComp('acos') then Result := tkKey else
      if KeyComp('max') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func39: TtkTokenKind;
begin
  if KeyComp('LOG10E') then Result := tkKey else
    if KeyComp('LOG2E') then Result := tkKey else
      if KeyComp('for') then Result := tkKey else
        if KeyComp('checked') then Result := tkKey else
          if KeyComp('for') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func40: TtkTokenKind;
begin
  if KeyComp('eval') then Result := tkKey else
    if KeyComp('src') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func41: TtkTokenKind;
begin
  if KeyComp('else') then Result := tkKey else
    if KeyComp('var') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func42: TtkTokenKind;
begin
  if KeyComp('Math') then Result := tkKey else
    if KeyComp('self') then Result := tkKey else
      if KeyComp('Math') then Result := tkKey else
        if KeyComp('sin') then Result := tkKey else
          if KeyComp('new') then Result := tkKey else
            if KeyComp('sub') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func43: TtkTokenKind;
begin
  if KeyComp('asin') then Result := tkKey else
    if KeyComp('Frame') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func44: TtkTokenKind;
begin
  if KeyComp('Hidden') then Result := tkKey else
    if KeyComp('UTC') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func45: TtkTokenKind;
begin
  if KeyComp('exp') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func46: TtkTokenKind;
begin
  if KeyComp('Link') then Result := tkKey else
    if KeyComp('link') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func47: TtkTokenKind;
begin
  if KeyComp('Radio') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func48: TtkTokenKind;
begin
  if KeyComp('join') then Result := tkKey else
    if KeyComp('embeds') then Result := tkKey else
      if KeyComp('blink') then Result := tkKey else
        if KeyComp('fixed') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func49: TtkTokenKind;
begin
  if KeyComp('escape') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func50: TtkTokenKind;
begin
  if KeyComp('open') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func51: TtkTokenKind;
begin
  if KeyComp('charAt') then Result := tkKey else
    if KeyComp('top') then Result := tkKey else
      if KeyComp('URL') then Result := tkKey else
        if KeyComp('caller') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func52: TtkTokenKind;
begin
  if KeyComp('Form') then Result := tkKey else
    if KeyComp('form') then Result := tkKey else
      if KeyComp('hspace') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func53: TtkTokenKind;
begin
  if KeyComp('blur') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func54: TtkTokenKind;
begin
  if KeyComp('pow') then Result := tkKey else
    if KeyComp('close') then Result := tkKey else
      if KeyComp('search') then Result := tkKey else
        if KeyComp('images') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func55: TtkTokenKind;
begin
  if KeyComp('object') then Result := tkKey else
    if KeyComp('object') then Result := tkKey else
      if KeyComp('reload') then Result := tkKey else
        if KeyComp('object') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func56: TtkTokenKind;
begin
  if KeyComp('this') then Result := tkKey else
    if KeyComp('alert') then Result := tkKey else
      if KeyComp('sup') then Result := tkKey else
        if KeyComp('domain') then Result := tkKey else
          if KeyComp('index') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func57: TtkTokenKind;
begin
  if KeyComp('isNaN') then Result := tkKey else
    if KeyComp('small') then Result := tkKey else
      if KeyComp('while') then Result := tkKey else
        if KeyComp('height') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func58: TtkTokenKind;
begin
  if KeyComp('cookie') then Result := tkKey else
    if KeyComp('closed') then Result := tkKey else
      if KeyComp('loop') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func59: TtkTokenKind;
begin
  if KeyComp('parse') then Result := tkKey else
    if KeyComp('Anchor') then Result := tkKey else
      if KeyComp('anchor') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func60: TtkTokenKind;
begin
  if KeyComp('with') then Result := tkKey else
    if KeyComp('replace') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func61: TtkTokenKind;
begin
  if KeyComp('onLoad') then Result := tkKey else
    if KeyComp('value') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func62: TtkTokenKind;
begin
  if KeyComp('action') then Result := tkKey else
    if KeyComp('getDate') then Result := tkKey else
      if KeyComp('getDay') then Result := tkKey else
        if KeyComp('border') then Result := tkKey else
          if KeyComp('host') then Result := tkKey else
            if KeyComp('frames') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func63: TtkTokenKind;
begin
  if KeyComp('Array') then Result := tkKey else
    if KeyComp('array') then Result := tkKey else
      if KeyComp('array') then Result := tkKey else
        if KeyComp('Array') then Result := tkKey else
          if KeyComp('next') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func64: TtkTokenKind;
begin
  if KeyComp('Boolean') then Result := tkKey else
    if KeyComp('Select') then Result := tkKey else
      if KeyComp('select') then Result := tkKey else
        if KeyComp('taint') then Result := tkKey else
          if KeyComp('focus') then Result := tkKey else
            if KeyComp('Boolean') then Result := tkKey else
              if KeyComp('width') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func65: TtkTokenKind;
begin
  if KeyComp('method') then Result := tkKey else
    if KeyComp('filename') then Result := tkKey else
      if KeyComp('method') then Result := tkKey else
        if KeyComp('links') then Result := tkKey else
          if KeyComp('method') then Result := tkKey else
            if KeyComp('random') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func66: TtkTokenKind;
begin
  if KeyComp('vspace') then Result := tkKey else
    if KeyComp('length') then Result := tkKey else
      if KeyComp('title') then Result := tkKey else
        if KeyComp('type') then Result := tkKey else
          if KeyComp('appName') then Result := tkKey else
            if KeyComp('floor') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func67: TtkTokenKind;
begin
  if KeyComp('onClick') then Result := tkKey else
    if KeyComp('onChange') then Result := tkKey else
      if KeyComp('reset') then Result := tkKey else
        if KeyComp('Reset') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func69: TtkTokenKind;
begin
  if KeyComp('port') then Result := tkKey else
    if KeyComp('Text') then Result := tkKey else
      if KeyComp('text') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func70: TtkTokenKind;
begin
  if KeyComp('Applet') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func71: TtkTokenKind;
begin
  if KeyComp('target') then Result := tkKey else
    if KeyComp('Checkbox') then Result := tkKey else
      if KeyComp('encoding') then Result := tkKey else
        if KeyComp('forms') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func72: TtkTokenKind;
begin
  if KeyComp('round') then Result := tkKey else
    if KeyComp('sort') then Result := tkKey else
      if KeyComp('bgColor') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func73: TtkTokenKind;
begin
  if KeyComp('italics') then Result := tkKey else
    if KeyComp('Number') then Result := tkKey else
      if KeyComp('Number') then Result := tkKey else
        if KeyComp('opener') then Result := tkKey else
          if KeyComp('selected') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func74: TtkTokenKind;
begin
  if KeyComp('sqrt') then Result := tkKey else
    if KeyComp('SQRT2') then Result := tkKey else
      if KeyComp('parent') then Result := tkKey else
        if KeyComp('setDate') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func75: TtkTokenKind;
begin
  if KeyComp('write') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func76: TtkTokenKind;
begin
  if KeyComp('fgColor') then Result := tkKey else
    if KeyComp('split') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func77: TtkTokenKind;
begin
  if KeyComp('javaEnabled') then Result := tkKey else
    if KeyComp('indexOf') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func78: TtkTokenKind;
begin
  if KeyComp('anchors') then Result := tkKey else
    if KeyComp('confirm') then Result := tkKey else
      if KeyComp('pathname') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func79: TtkTokenKind;
begin
  if KeyComp('Plugin') then Result := tkKey else
    if KeyComp('getTime') then Result := tkKey else
      if KeyComp('refresh') then Result := tkKey else
        if KeyComp('scroll') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func81: TtkTokenKind;
begin
  if KeyComp('getYear') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func82: TtkTokenKind;
begin
  if KeyComp('onBlur') then Result := tkKey else
    if KeyComp('strike') then Result := tkKey else
      if KeyComp('valueOf') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func83: TtkTokenKind;
begin
  if KeyComp('comment') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func84: TtkTokenKind;
begin
  if KeyComp('submit') then Result := tkKey else
    if KeyComp('unescape') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func85: TtkTokenKind;
begin
  if KeyComp('onAbort') then Result := tkKey else
    if KeyComp('forward') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func87: TtkTokenKind;
begin
  if KeyComp('String') then Result := tkKey else
    if KeyComp('String') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func88: TtkTokenKind;
begin
  if KeyComp('window') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func89: TtkTokenKind;
begin
  if KeyComp('location') then Result := tkKey else
    if KeyComp('complete') then Result := tkKey else
      if KeyComp('applets') then Result := tkKey else
        if KeyComp('Option') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func90: TtkTokenKind;
begin
  if KeyComp('lowsrc') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func91: TtkTokenKind;
begin
  if KeyComp('setTime') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func92: TtkTokenKind;
begin
  if KeyComp('Button') then Result := tkKey else
    if KeyComp('reverse') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func93: TtkTokenKind;
begin
  if KeyComp('appCodeName') then Result := tkKey else
    if KeyComp('setYear') then Result := tkKey else
      if KeyComp('referrer') then Result := tkKey else
        if KeyComp('elements') then Result := tkKey else
          if KeyComp('elements') then Result := tkKey else
            if KeyComp('onFocus') then Result := tkKey else
              if KeyComp('onSelect') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func94: TtkTokenKind;
begin
  if KeyComp('Textarea') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func95: TtkTokenKind;
begin
  if KeyComp('hostname') then Result := tkKey else
    if KeyComp('document') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func96: TtkTokenKind;
begin
  if KeyComp('onUnload') then Result := tkKey else
    if KeyComp('return') then Result := tkKey else
      if KeyComp('onReset') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func98: TtkTokenKind;
begin
  if KeyComp('prompt') then Result := tkKey else
    if KeyComp('plugins') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func99: TtkTokenKind;
begin
  if KeyComp('current') then Result := tkKey else
    if KeyComp('untaint') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func100: TtkTokenKind;
begin
  if KeyComp('status') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func101: TtkTokenKind;
begin
  if KeyComp('FileUpload') then Result := tkKey else
    if KeyComp('writeln') then Result := tkKey else
      if KeyComp('continue') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func102: TtkTokenKind;
begin
  if KeyComp('getMonth') then Result := tkKey else
    if KeyComp('Function') then Result := tkKey else
      if KeyComp('function') then Result := tkKey else
        if KeyComp('Function') then Result := tkKey else
          if KeyComp('parseInt') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func103: TtkTokenKind;
begin
  if KeyComp('onError') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func105: TtkTokenKind;
begin
  if KeyComp('SQRT1_2') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func106: TtkTokenKind;
begin
  if KeyComp('MimeType') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func107: TtkTokenKind;
begin
  if KeyComp('taintEnabled') then Result := tkKey else
    if KeyComp('navigator') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func108: TtkTokenKind;
begin
  if KeyComp('defaultChecked') then Result := tkKey else
    if KeyComp('options') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func109: TtkTokenKind;
begin
  if KeyComp('suffixes') then Result := tkKey else
    if KeyComp('linkColor') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func110: TtkTokenKind;
begin
  if KeyComp('userAgent') then Result := tkKey else
    if KeyComp('alinkColor') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func111: TtkTokenKind;
begin
  if KeyComp('getSeconds') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func113: TtkTokenKind;
begin
  if KeyComp('onSubmit') then Result := tkKey else
    if KeyComp('parseFloat') then Result := tkKey else
      if KeyComp('getHours') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func114: TtkTokenKind;
begin
  if KeyComp('fontsize') then Result := tkKey else
    if KeyComp('history') then Result := tkKey else
      if KeyComp('setMonth') then Result := tkKey else
        if KeyComp('protocol') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func115: TtkTokenKind;
begin
  if KeyComp('Password') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func117: TtkTokenKind;
begin
  if KeyComp('lastModified') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func118: TtkTokenKind;
begin
  if KeyComp('fontcolor') then Result := tkKey else
    if KeyComp('arguments') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func122: TtkTokenKind;
begin
  if KeyComp('toString') then Result := tkKey else
    if KeyComp('enabledPlugin') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func123: TtkTokenKind;
begin
  if KeyComp('setSeconds') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func125: TtkTokenKind;
begin
  if KeyComp('previous') then Result := tkKey else
    if KeyComp('setHours') then Result := tkKey else
      if KeyComp('mimeTypes') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func128: TtkTokenKind;
begin
  if KeyComp('MIN_VALUE') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func129: TtkTokenKind;
begin
  if KeyComp('lastIndexOf') then Result := tkKey else
    if KeyComp('substring') then Result := tkKey else
      if KeyComp('selectedIndex') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func130: TtkTokenKind;
begin
  if KeyComp('defaultValue') then Result := tkKey else
    if KeyComp('MAX_VALUE') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func131: TtkTokenKind;
begin
  if KeyComp('vlinkColor') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func132: TtkTokenKind;
begin
  if KeyComp('description') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func133: TtkTokenKind;
begin
  if KeyComp('property') then Result := tkKey else
    if KeyComp('getMinutes') then Result := tkKey else
      if KeyComp('property') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func135: TtkTokenKind;
begin
  if KeyComp('appVersion') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func136: TtkTokenKind;
begin
  if KeyComp('toLowerCase') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func139: TtkTokenKind;
begin
  if KeyComp('toUpperCase') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func142: TtkTokenKind;
begin
  if KeyComp('defaultSelected') then Result := tkKey else
    if KeyComp('clearTimeout') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func145: TtkTokenKind;
begin
  if KeyComp('setMinutes') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func147: TtkTokenKind;
begin
  if KeyComp('setTimeout') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func150: TtkTokenKind;
begin
  if KeyComp('prototype') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func158: TtkTokenKind;
begin
  if KeyComp('onMouseOut') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func162: TtkTokenKind;
begin
  if KeyComp('toGMTString') then Result := tkKey else
    if KeyComp('onMouseOver') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func166: TtkTokenKind;
begin
  if KeyComp('constructor') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func169: TtkTokenKind;
begin
  if KeyComp('defaultStatus') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func170: TtkTokenKind;
begin
  if KeyComp('toLocaleString') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func210: TtkTokenKind;
begin
  if KeyComp('getTimezoneOffset') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func220: TtkTokenKind;
begin
  if KeyComp('NEGATIVE_INFINITY') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.Func252: TtkTokenKind;
begin
  if KeyComp('POSITIVE_INFINITY') then Result := tkKey else Result := tkIdentifier;
end;

function TpsvJScriptRTF.AltFunc: TtkTokenKind;
begin
  Result := tkIdentifier;
end;

function TpsvJScriptRTF.IdentKind(MayBe: PChar): TtkTokenKind;
var
  HashKey: Integer;
begin
  fToIdent := MayBe;
  HashKey := KeyHash(MayBe);
  if HashKey < 253 then
    Result := fIdentFuncTable[HashKey]
  else
    Result := tkIdentifier;
end;

procedure TpsvJScriptRTF.MakeMethodTables;
var
  I: Char;
begin
  for I := #0 to #255 do
    case I of
      '&': fProcTable[I] := AndSymbolProc;
      '#': fProcTable[I] := AsciiCharProc;
      #13: fProcTable[I] := CRProc;
      'A'..'Z', 'a'..'z', '_': fProcTable[I] := IdentProc;
      '$': fProcTable[I] := IntegerProc;
      #10: fProcTable[I] := LFProc;
      '-': fProcTable[I] := MinusProc;
      '%': fProcTable[I] := ModSymbolProc;
      #0: fProcTable[I] := NullProc;
      '0'..'9': fProcTable[I] := NumberProc;
      '|': fProcTable[I] := OrSymbolProc;
      '+': fProcTable[I] := PlusProc;
      '.': fProcTable[I] := PointProc;
      '/': fProcTable[I] := SlashProc;
      #1..#9, #11, #12, #14..#32: fProcTable[I] := SpaceProc;
      '*': fProcTable[I] := StarProc;
      '"', #39: fProcTable[I] := StringProc;
//      '~', '{', '}', ',', '(', ')':
      '~', '{', '}', ',', '(', ')', '[', ']', '<', '>', ':', ';', '!', '=':     //satya 2000-07-15
        fProcTable[I] := SymbolProc;
    else
      fProcTable[I] := UnknownProc;
    end;
end;

constructor TpsvJScriptRTF.Create;
begin
  inherited Create;
  InitIdent;
  MakeMethodTables;
  fRange := rsUnknown;
  CreateColorTable([clGreen, //comment
                    clBlack, //identifier
                    clNavy,  //key
                    clBlue,  //number
                    clBlack,
                    clBlack,
                    clBlack,
                    clBlack]);
end;

procedure TpsvJScriptRTF.SetLine(NewValue: String; LineNumber: Integer);
begin
  fLine := PChar(NewValue);
  Run := 0;
  fLineNumber := LineNumber;
  Next;
end;

procedure TpsvJScriptRTF.AndSymbolProc;
begin
  fTokenID := tkSymbol;
  inc(Run);
  if fLine[Run] in ['=', '&'] then inc(Run);
end;

procedure TpsvJScriptRTF.AsciiCharProc;
begin
  fTokenID := tkString;
  inc(Run);
  while FLine[Run] in ['0'..'9'] do inc(Run);
end;

{begin}                                                                         //mh 2000-07-14
// copied from CSS highlighter
procedure TpsvJScriptRTF.CommentProc;
begin
  if fLine[Run] = #0 then
    fTokenID := tkNull
  else begin
    fTokenID := tkComment;
    repeat
      if (fLine[Run] = '*') and (fLine[Run + 1] = '/') then begin
        fRange := rsUnKnown;
        inc(Run, 2);
        break;
      end;
      inc(Run);
    until fLine[Run] in [#0, #10, #13];
  end;
end;
{end}                                                                           //mh 2000-07-14

procedure TpsvJScriptRTF.CRProc;
begin
  fTokenID := tkSpace;
  inc(Run);
  if fLine[Run] = #10 then inc(Run);
end;

procedure TpsvJScriptRTF.IdentProc;
begin
  fTokenID := IdentKind((fLine + Run));
  inc(Run, fStringLen);
  while Identifiers[fLine[Run]] do inc(Run);
end;

procedure TpsvJScriptRTF.IntegerProc;
begin
  inc(Run);
  fTokenID := tkNumber;
  while FLine[Run] in ['0'..'9', 'A'..'F', 'a'..'f'] do inc(Run);
end;

procedure TpsvJScriptRTF.LFProc;
begin
  fTokenID := tkSpace;
  inc(Run);
end;

procedure TpsvJScriptRTF.MinusProc;
begin
  fTokenID := tkSymbol;
  inc(Run);
  if fLine[Run] in ['=', '-', '>'] then inc(Run);
end;

procedure TpsvJScriptRTF.ModSymbolProc;
begin
  fTokenID := tkSpace;
  inc(Run);
  if fLine[Run] = '=' then inc(Run);
end;

procedure TpsvJScriptRTF.NullProc;
begin
  fTokenID := tkNull;
end;

procedure TpsvJScriptRTF.NumberProc;
begin
  inc(Run);
  fTokenID := tkNumber;
  while FLine[Run] in ['0'..'9', '.', 'e', 'E'] do
  begin
    case FLine[Run] of
      '.':
        if FLine[Run + 1] = '.' then break;
    end;
    inc(Run);
  end;
end;

procedure TpsvJScriptRTF.OrSymbolProc;
begin
  fTokenID := tkSymbol;
  inc(Run);
  if fLine[Run] in ['=', '|'] then inc(Run);
end;

procedure TpsvJScriptRTF.PlusProc;
begin
  fTokenID := tkSymbol;
  inc(Run);
  if fLine[Run] in ['=', '+'] then inc(Run);
end;

procedure TpsvJScriptRTF.PointProc;
begin
  fTokenID := tkSymbol;
  inc(Run);
  if (fLine[Run] = '.') and (fLine[Run + 1] = '.') then inc(Run, 2);
end;

procedure TpsvJScriptRTF.SlashProc;
begin
{begin}                                                                         //mh 2000-07-14
  Inc(Run);
  case fLine[Run] of
    '/': begin
           fTokenID := tkComment;
           repeat
             Inc(Run);
           until fLine[Run] in [#0, #10, #13];
         end;
    '*': begin
           fTokenID := tkComment;
           fRange := rsAnsi;
           repeat
             Inc(Run);
             if (fLine[Run] = '*') and (fLine[Run + 1] = '/') then begin
               fRange := rsUnKnown;
               Inc(Run, 2);
               break;
             end;
           until fLine[Run] in [#0, #10, #13];
         end;
    '=': begin
           Inc(Run);
           fTokenID := tkSymbol;
         end;
    else
      fTokenID := tkSymbol;
  end;
{end}                                                                           //mh 2000-07-14
end;

procedure TpsvJScriptRTF.SpaceProc;
begin
  inc(Run);
  fTokenID := tkSpace;
  while FLine[Run] in [#1..#9, #11, #12, #14..#32] do inc(Run);
end;

procedure TpsvJScriptRTF.StarProc;
begin
  fTokenID := tkSpace;
  inc(Run);
  if fLine[Run] = '=' then inc(Run);
end;

procedure TpsvJScriptRTF.StringProc;
var
  l_strChar : String;
begin
  fTokenID := tkString;
  l_strChar := FLine[Run];   // We could have '"' or #39
  if (FLine[Run + 1] = l_strChar) and (FLine[Run + 2] = l_strChar) then inc(Run, 2);
  repeat
    case FLine[Run] of
      #0, #10, #13: break;
    end;
    inc(Run);
  until (FLine[Run] = l_strChar);
  if FLine[Run] <> #0 then inc(Run);
end;

procedure TpsvJScriptRTF.SymbolProc;
begin
  inc(Run);
  fTokenId := tkSymbol;
end;

procedure TpsvJScriptRTF.UnknownProc;
begin
  inc(Run);
  fTokenID := tkUnknown;
end;

procedure TpsvJScriptRTF.Next;
begin
  fTokenPos := Run;
{begin}                                                                         //mh 2000-07-14
  if fRange = rsANSI then
    CommentProc
  else
{end}                                                                           //mh 2000-07-14
    fProcTable[fLine[Run]];
end;


function TpsvJScriptRTF.GetEOL: Boolean;
begin
  Result := fTokenID = tkNull;
end;

function TpsvJScriptRTF.GetRange: Pointer;
begin
  Result := Pointer(fRange);
end;

function TpsvJScriptRTF.GetToken: String;
var
  Len: LongInt;
begin
  Len := Run - fTokenPos;
  SetString(Result, (FLine + fTokenPos), Len);
end;

function TpsvJScriptRTF.GetTokenID: TtkTokenKind;
begin
  Result := fTokenId;
end;

function TpsvJScriptRTF.GetTokenAttribute: integer;
begin
  case GetTokenID of
    tkComment: Result := 1;
    tkIdentifier: Result := 2;
    tkKey: Result := 3;
    tkNumber: Result := 4;
    tkSpace: Result := 5;
    tkString: Result := 6;
    tkSymbol: Result := 7;
    tkUnknown: Result := 8;
    else Result := 8;
  end;

end;

function TpsvJScriptRTF.GetTokenKind: integer;
begin
  Result := Ord(fTokenId);
end;

function TpsvJScriptRTF.GetTokenPos: Integer;
begin
  Result := fTokenPos;
end;

procedure TpsvJScriptRTF.ReSetRange;
begin
  fRange := rsUnknown;
end;

procedure TpsvJScriptRTF.SetRange(Value: Pointer);
begin
  fRange := TRangeState(Value);
end;

procedure TpsvJScriptRTF.PrepareToken(var AToken : string);
var St : string;
begin
  St := AToken;
  St := StringReplace(St,'\','\\',[rfReplaceAll]);
  St := StringReplace(St,'{','\{',[rfReplaceAll]);
  St := StringReplace(St,'}','\}',[rfReplaceAll]);
  AToken := St;
end;

procedure TpsvJScriptRTF.SetupDefaultColors;
begin
  CreateColorTable([clGreen, //comment
                    clBlack, //identifier
                    clNavy,  //key
                    clBlue,  //number
                    clBlack,
                    clBlack,
                    clBlack,
                    clBlack]);
end;

initialization
  MakeIdentTable;
end.
