unit IFSI_IBCustomDataSet;
{
This file has been generated by UnitParser v0.4, written by M. Knight.
Source Code from Carlo Kok has been used to implement various sections of
UnitParser. Components of ifps3 are used in the construction of UnitParser,
code implementing the class wrapper is taken from Carlo Kok''s conv unility

}
{$I ifps3_def.inc}
interface
 
uses
   SysUtils
  ,Classes
  ,IFPS3CompExec
  ,ifpscomp
  ,ifps3
  ;
 
type 
(*----------------------------------------------------------------------------*)
  TIFPS3CE_IBCustomDataSet = class(TIFPS3Plugin)
  protected
    procedure CompOnUses(CompExec: TIFPS3CompExec); override;
    procedure ExecOnUses(CompExec: TIFPS3CompExec); override;
    procedure CompileImport1(CompExec: TIFPS3CompExec); override;
    procedure CompileImport2(CompExec: TIFPS3CompExec); override;
    procedure ExecImport1(CompExec: TIFPS3CompExec; const ri: TIFPSRuntimeClassImporter); override;
    procedure ExecImport2(CompExec: TIFPS3CompExec; const ri: TIFPSRuntimeClassImporter); override;
  end;
 
 
(*
{ compile-time registration functions }
procedure SIRegister_TIBDATASET(CL: TIFPSPascalCompiler);
procedure SIRegister_TIBCUSTOMDATASET(CL: TIFPSPascalCompiler);
procedure SIRegister_TIBGENERATORFIELD(CL: TIFPSPascalCompiler);
procedure SIRegister_TIBDATALINK(CL: TIFPSPascalCompiler);
procedure SIRegister_TIBBCDFIELD(CL: TIFPSPascalCompiler);
procedure SIRegister_TIBSTRINGFIELD(CL: TIFPSPascalCompiler);
procedure SIRegister_TIBDATASETUPDATEOBJECT(CL: TIFPSPascalCompiler);
procedure SIRegister_IBCustomDataSet(CL: TIFPSPascalCompiler);
 
{ run-time registration functions }
procedure RIRegister_TIBDATASET(CL: TIFPSRuntimeClassImporter);
procedure RIRegister_TIBCUSTOMDATASET(CL: TIFPSRuntimeClassImporter);
procedure RIRegister_TIBGENERATORFIELD(CL: TIFPSRuntimeClassImporter);
procedure RIRegister_TIBDATALINK(CL: TIFPSRuntimeClassImporter);
procedure RIRegister_TIBBCDFIELD(CL: TIFPSRuntimeClassImporter);
procedure RIRegister_TIBSTRINGFIELD(CL: TIFPSRuntimeClassImporter);
procedure RIRegister_TIBDATASETUPDATEOBJECT(CL: TIFPSRuntimeClassImporter);
procedure RIRegister_IBCustomDataSet(CL: TIFPSRuntimeClassImporter);
*)


implementation


uses
   WINDOWS
  ,CONTROLS
  ,IBEXTERNALS
  ,IB
  ,IBHEADER
  ,STDVCL
  ,IBDATABASE
  ,IBSQL
  ,DB
  ,IBUTILS
  ,IBBLOB
  ,IBCustomDataSet
  ;
 
 
{ compile-time importer function }
(*----------------------------------------------------------------------------
 Sometimes the CL.AddClassN() fails to correctly register a class, 
 for unknown (at least to me) reasons
 So, you may use the below RegClassS() replacing the CL.AddClassN()
 of the various SIRegister_XXXX calls 
 ----------------------------------------------------------------------------*)
function RegClassS(CL: TIFPSPascalCompiler; const InheritsFrom, Classname: string): TIFPSCompileTimeClass;
begin
  Result := CL.FindClass(Classname);
  if Result = nil then
    Result := CL.AddClassN(CL.FindClass(InheritsFrom), Classname)
  else Result.ClassInheritsFrom := CL.FindClass(InheritsFrom);
end;
  
  
(* === compile-time registration functions === *)
(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBDATASET(CL: TIFPSPascalCompiler);
begin
  //with RegClassS(CL,'TIBCUSTOMDATASET', 'TIBDATASET') do
  with CL.AddClassN(CL.FindClass('TIBCUSTOMDATASET'),'TIBDATASET') do
  begin
    RegisterMethod('Procedure PREPARE');
    RegisterMethod('Procedure UNPREPARE');
    RegisterMethod('Procedure BATCHINPUT( INPUTOBJECT : TIBBATCHINPUT)');
    RegisterMethod('Procedure BATCHOUTPUT( OUTPUTOBJECT : TIBBATCHOUTPUT)');
    RegisterMethod('Procedure EXECSQL');
    RegisterMethod('Function PARAMBYNAME( IDX : STRING) : TIBXSQLVAR');
    RegisterProperty('PREPARED', 'BOOLEAN', iptr);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBCUSTOMDATASET(CL: TIFPSPascalCompiler);
begin
  //with RegClassS(CL,'TDATASET', 'TIBCUSTOMDATASET') do
  with CL.AddClassN(CL.FindClass('TDATASET'),'TIBCUSTOMDATASET') do
  begin
    RegisterMethod('Procedure APPLYUPDATES');
    RegisterMethod('Function CACHEDUPDATESTATUS : TCACHEDUPDATESTATUS');
    RegisterMethod('Procedure CANCELUPDATES');
    RegisterMethod('Procedure FETCHALL');
    RegisterMethod('Function LOCATENEXT( const KEYFIELDS : STRING; const KEYVALUES : VARIANT; OPTIONS : TLOCATEOPTIONS) : BOOLEAN');
    RegisterMethod('Procedure RECORDMODIFIED( VALUE : BOOLEAN)');
    RegisterMethod('Procedure REVERTRECORD');
    RegisterMethod('Procedure UNDELETE');
    RegisterMethod('Function CURRENT : TIBXSQLDA');
    RegisterMethod('Function SQLTYPE : TIBSQLTYPES');
    RegisterProperty('DBHANDLE', 'PISC_DB_HANDLE', iptr);
    RegisterProperty('TRHANDLE', 'PISC_TR_HANDLE', iptr);
    RegisterProperty('UPDATEOBJECT', 'TIBDATASETUPDATEOBJECT', iptrw);
    RegisterProperty('UPDATESPENDING', 'BOOLEAN', iptr);
    RegisterProperty('UPDATERECORDTYPES', 'TIBUPDATERECORDTYPES', iptrw);
    RegisterProperty('ROWSAFFECTED', 'INTEGER', iptr);
    RegisterProperty('PLAN', 'STRING', iptr);
    RegisterProperty('DATABASE', 'TIBDATABASE', iptrw);
    RegisterProperty('TRANSACTION', 'TIBTRANSACTION', iptrw);
    RegisterProperty('FORCEDREFRESH', 'BOOLEAN', iptrw);
    RegisterProperty('ONUPDATEERROR', 'TIBUPDATEERROREVENT', iptrw);
    RegisterProperty('ONUPDATERECORD', 'TIBUPDATERECORDEVENT', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBGENERATORFIELD(CL: TIFPSPascalCompiler);
begin
  //with RegClassS(CL,'TPERSISTENT', 'TIBGENERATORFIELD') do
  with CL.AddClassN(CL.FindClass('TPERSISTENT'),'TIBGENERATORFIELD') do
  begin
    RegisterMethod('Constructor CREATE( ADATASET : TIBCUSTOMDATASET)');
    RegisterMethod('Function VALUENAME : STRING');
    RegisterMethod('Procedure APPLY');
    RegisterProperty('FIELD', 'STRING', iptrw);
    RegisterProperty('GENERATOR', 'STRING', iptrw);
    RegisterProperty('INCREMENTBY', 'INTEGER', iptrw);
    RegisterProperty('APPLYEVENT', 'TIBGENERATORAPPLYEVENT', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBDATALINK(CL: TIFPSPascalCompiler);
begin
  //with RegClassS(CL,'TDETAILDATALINK', 'TIBDATALINK') do
  with CL.AddClassN(CL.FindClass('TDETAILDATALINK'),'TIBDATALINK') do
  begin
    RegisterMethod('Constructor CREATE( ADATASET : TIBCUSTOMDATASET)');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBBCDFIELD(CL: TIFPSPascalCompiler);
begin
  //with RegClassS(CL,'TBCDFIELD', 'TIBBCDFIELD') do
  with CL.AddClassN(CL.FindClass('TBCDFIELD'),'TIBBCDFIELD') do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBSTRINGFIELD(CL: TIFPSPascalCompiler);
begin
  //with RegClassS(CL,'TSTRINGFIELD', 'TIBSTRINGFIELD') do
  with CL.AddClassN(CL.FindClass('TSTRINGFIELD'),'TIBSTRINGFIELD') do
  begin
    RegisterMethod('Function GETVALUE( var VALUE : STRING) : BOOLEAN');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_TIBDATASETUPDATEOBJECT(CL: TIFPSPascalCompiler);
begin
  //with RegClassS(CL,'TCOMPONENT', 'TIBDATASETUPDATEOBJECT') do
  with CL.AddClassN(CL.FindClass('TCOMPONENT'),'TIBDATASETUPDATEOBJECT') do
  begin
    RegisterProperty('REFRESHSQL', 'TSTRINGS', iptrw);
  end;
end;

(*----------------------------------------------------------------------------*)
procedure SIRegister_IBCustomDataSet(CL: TIFPSPascalCompiler);
begin
 CL.AddConstantN('BUFFERCACHESIZE','LONGINT').SetInt( 1000);
 CL.AddConstantN('UNICACHE','LONGINT').SetInt( 2);
  CL.AddClassN(CL.FindClass('TOBJECT'),'TIBCUSTOMDATASET');
  CL.AddClassN(CL.FindClass('TOBJECT'),'TIBDATASET');
  SIRegister_TIBDATASETUPDATEOBJECT(CL);
  CL.AddTypeS('TCACHEDUPDATESTATUS', '( CUSUNMODIFIED, CUSMODIFIED, CUSINSERTED'
   +', CUSDELETED, CUSUNINSERTED )');
  SIRegister_TIBSTRINGFIELD(CL);
  SIRegister_TIBBCDFIELD(CL);
  SIRegister_TIBDATALINK(CL);
  CL.AddTypeS('TIBGENERATORAPPLYEVENT', '( GAMONNEWRECORD, GAMONPOST, GAMONSERV'
   +'ER )');
  SIRegister_TIBGENERATORFIELD(CL);
  CL.AddTypeS('TIBUPDATEACTION', '( UAFAIL, UAABORT, UASKIP, UARETRY, UAAPPLY, '
   +'UAAPPLIED )');
  CL.AddTypeS('TIBUPDATEERROREVENT', 'Procedure ( DATASET : TDATASET; E : EDATA'
   +'BASEERROR; UPDATEKIND : TUPDATEKIND; var UPDATEACTION : TIBUPDATEACTION)');
  CL.AddTypeS('TIBUPDATERECORDEVENT', 'Procedure ( DATASET : TDATASET; UPDATEKI'
   +'ND : TUPDATEKIND; var UPDATEACTION : TIBUPDATEACTION)');
  CL.AddTypeS('TIBUPDATERECORDTYPES', 'set of TCACHEDUPDATESTATUS');
  CL.AddTypeS('TLIVEMODE', '( LMINSERT, LMMODIFY, LMDELETE, LMREFRESH )');
  CL.AddTypeS('TLIVEMODES', 'set of TLIVEMODE');
  SIRegister_TIBCUSTOMDATASET(CL);
  SIRegister_TIBDATASET(CL);
end;

(* === run-time registration functions === *)
(*----------------------------------------------------------------------------*)
procedure TIBDATASETPREPARED_R(Self: TIBDATASET; var T: BOOLEAN);
begin T := Self.PREPARED; end;

(*----------------------------------------------------------------------------*)
procedure TIBCUSTOMDATASETONUPDATERECORD_W(Self: TIBCUSTOMDATASET; const T: TIBUPDATERECORDEVENT);
begin Self.ONUPDATERECORD := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBCUSTOMDATASETONUPDATERECORD_R(Self: TIBCUSTOMDATASET; var T: TIBUPDATERECORDEVENT);
begin T := Self.ONUPDATERECORD; end;

(*----------------------------------------------------------------------------*)
procedure TIBCUSTOMDATASETONUPDATEERROR_W(Self: TIBCUSTOMDATASET; const T: TIBUPDATEERROREVENT);
begin Self.ONUPDATEERROR := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBCUSTOMDATASETONUPDATEERROR_R(Self: TIBCUSTOMDATASET; var T: TIBUPDATEERROREVENT);
begin T := Self.ONUPDATEERROR; end;

(*----------------------------------------------------------------------------*)
procedure TIBCUSTOMDATASETFORCEDREFRESH_W(Self: TIBCUSTOMDATASET; const T: BOOLEAN);
begin Self.FORCEDREFRESH := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBCUSTOMDATASETFORCEDREFRESH_R(Self: TIBCUSTOMDATASET; var T: BOOLEAN);
begin T := Self.FORCEDREFRESH; end;

(*----------------------------------------------------------------------------*)
procedure TIBCUSTOMDATASETTRANSACTION_W(Self: TIBCUSTOMDATASET; const T: TIBTRANSACTION);
begin Self.TRANSACTION := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBCUSTOMDATASETTRANSACTION_R(Self: TIBCUSTOMDATASET; var T: TIBTRANSACTION);
begin T := Self.TRANSACTION; end;

(*----------------------------------------------------------------------------*)
procedure TIBCUSTOMDATASETDATABASE_W(Self: TIBCUSTOMDATASET; const T: TIBDATABASE);
begin Self.DATABASE := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBCUSTOMDATASETDATABASE_R(Self: TIBCUSTOMDATASET; var T: TIBDATABASE);
begin T := Self.DATABASE; end;

(*----------------------------------------------------------------------------*)
procedure TIBCUSTOMDATASETPLAN_R(Self: TIBCUSTOMDATASET; var T: STRING);
begin T := Self.PLAN; end;

(*----------------------------------------------------------------------------*)
procedure TIBCUSTOMDATASETROWSAFFECTED_R(Self: TIBCUSTOMDATASET; var T: INTEGER);
begin T := Self.ROWSAFFECTED; end;

(*----------------------------------------------------------------------------*)
procedure TIBCUSTOMDATASETUPDATERECORDTYPES_W(Self: TIBCUSTOMDATASET; const T: TIBUPDATERECORDTYPES);
begin Self.UPDATERECORDTYPES := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBCUSTOMDATASETUPDATERECORDTYPES_R(Self: TIBCUSTOMDATASET; var T: TIBUPDATERECORDTYPES);
begin T := Self.UPDATERECORDTYPES; end;

(*----------------------------------------------------------------------------*)
procedure TIBCUSTOMDATASETUPDATESPENDING_R(Self: TIBCUSTOMDATASET; var T: BOOLEAN);
begin T := Self.UPDATESPENDING; end;

(*----------------------------------------------------------------------------*)
procedure TIBCUSTOMDATASETUPDATEOBJECT_W(Self: TIBCUSTOMDATASET; const T: TIBDATASETUPDATEOBJECT);
begin Self.UPDATEOBJECT := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBCUSTOMDATASETUPDATEOBJECT_R(Self: TIBCUSTOMDATASET; var T: TIBDATASETUPDATEOBJECT);
begin T := Self.UPDATEOBJECT; end;

(*----------------------------------------------------------------------------*)
procedure TIBCUSTOMDATASETTRHANDLE_R(Self: TIBCUSTOMDATASET; var T: PISC_TR_HANDLE);
begin T := Self.TRHANDLE; end;

(*----------------------------------------------------------------------------*)
procedure TIBCUSTOMDATASETDBHANDLE_R(Self: TIBCUSTOMDATASET; var T: PISC_DB_HANDLE);
begin T := Self.DBHANDLE; end;

(*----------------------------------------------------------------------------*)
procedure TIBGENERATORFIELDAPPLYEVENT_W(Self: TIBGENERATORFIELD; const T: TIBGENERATORAPPLYEVENT);
begin Self.APPLYEVENT := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBGENERATORFIELDAPPLYEVENT_R(Self: TIBGENERATORFIELD; var T: TIBGENERATORAPPLYEVENT);
begin T := Self.APPLYEVENT; end;

(*----------------------------------------------------------------------------*)
procedure TIBGENERATORFIELDINCREMENTBY_W(Self: TIBGENERATORFIELD; const T: INTEGER);
begin Self.INCREMENTBY := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBGENERATORFIELDINCREMENTBY_R(Self: TIBGENERATORFIELD; var T: INTEGER);
begin T := Self.INCREMENTBY; end;

(*----------------------------------------------------------------------------*)
procedure TIBGENERATORFIELDGENERATOR_W(Self: TIBGENERATORFIELD; const T: STRING);
begin Self.GENERATOR := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBGENERATORFIELDGENERATOR_R(Self: TIBGENERATORFIELD; var T: STRING);
begin T := Self.GENERATOR; end;

(*----------------------------------------------------------------------------*)
procedure TIBGENERATORFIELDFIELD_W(Self: TIBGENERATORFIELD; const T: STRING);
begin Self.FIELD := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBGENERATORFIELDFIELD_R(Self: TIBGENERATORFIELD; var T: STRING);
begin T := Self.FIELD; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATASETUPDATEOBJECTREFRESHSQL_W(Self: TIBDATASETUPDATEOBJECT; const T: TSTRINGS);
begin Self.REFRESHSQL := T; end;

(*----------------------------------------------------------------------------*)
procedure TIBDATASETUPDATEOBJECTREFRESHSQL_R(Self: TIBDATASETUPDATEOBJECT; var T: TSTRINGS);
begin T := Self.REFRESHSQL; end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBDATASET(CL: TIFPSRuntimeClassImporter);
begin
  with CL.Add(TIBDATASET) do
  begin
    RegisterMethod(@TIBDATASET.PREPARE, 'PREPARE');
    RegisterMethod(@TIBDATASET.UNPREPARE, 'UNPREPARE');
    RegisterMethod(@TIBDATASET.BATCHINPUT, 'BATCHINPUT');
    RegisterMethod(@TIBDATASET.BATCHOUTPUT, 'BATCHOUTPUT');
    RegisterMethod(@TIBDATASET.EXECSQL, 'EXECSQL');
    RegisterMethod(@TIBDATASET.PARAMBYNAME, 'PARAMBYNAME');
    RegisterPropertyHelper(@TIBDATASETPREPARED_R,nil,'PREPARED');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBCUSTOMDATASET(CL: TIFPSRuntimeClassImporter);
begin
  with CL.Add(TIBCUSTOMDATASET) do
  begin
    RegisterMethod(@TIBCUSTOMDATASET.APPLYUPDATES, 'APPLYUPDATES');
    RegisterMethod(@TIBCUSTOMDATASET.CACHEDUPDATESTATUS, 'CACHEDUPDATESTATUS');
    RegisterMethod(@TIBCUSTOMDATASET.CANCELUPDATES, 'CANCELUPDATES');
    RegisterMethod(@TIBCUSTOMDATASET.FETCHALL, 'FETCHALL');
    RegisterMethod(@TIBCUSTOMDATASET.LOCATENEXT, 'LOCATENEXT');
    RegisterMethod(@TIBCUSTOMDATASET.RECORDMODIFIED, 'RECORDMODIFIED');
    RegisterMethod(@TIBCUSTOMDATASET.REVERTRECORD, 'REVERTRECORD');
    RegisterMethod(@TIBCUSTOMDATASET.UNDELETE, 'UNDELETE');
    RegisterMethod(@TIBCUSTOMDATASET.CURRENT, 'CURRENT');
    RegisterMethod(@TIBCUSTOMDATASET.SQLTYPE, 'SQLTYPE');
    RegisterPropertyHelper(@TIBCUSTOMDATASETDBHANDLE_R,nil,'DBHANDLE');
    RegisterPropertyHelper(@TIBCUSTOMDATASETTRHANDLE_R,nil,'TRHANDLE');
    RegisterPropertyHelper(@TIBCUSTOMDATASETUPDATEOBJECT_R,@TIBCUSTOMDATASETUPDATEOBJECT_W,'UPDATEOBJECT');
    RegisterPropertyHelper(@TIBCUSTOMDATASETUPDATESPENDING_R,nil,'UPDATESPENDING');
    RegisterPropertyHelper(@TIBCUSTOMDATASETUPDATERECORDTYPES_R,@TIBCUSTOMDATASETUPDATERECORDTYPES_W,'UPDATERECORDTYPES');
    RegisterPropertyHelper(@TIBCUSTOMDATASETROWSAFFECTED_R,nil,'ROWSAFFECTED');
    RegisterPropertyHelper(@TIBCUSTOMDATASETPLAN_R,nil,'PLAN');
    RegisterPropertyHelper(@TIBCUSTOMDATASETDATABASE_R,@TIBCUSTOMDATASETDATABASE_W,'DATABASE');
    RegisterPropertyHelper(@TIBCUSTOMDATASETTRANSACTION_R,@TIBCUSTOMDATASETTRANSACTION_W,'TRANSACTION');
    RegisterPropertyHelper(@TIBCUSTOMDATASETFORCEDREFRESH_R,@TIBCUSTOMDATASETFORCEDREFRESH_W,'FORCEDREFRESH');
    RegisterEventPropertyHelper(@TIBCUSTOMDATASETONUPDATEERROR_R,@TIBCUSTOMDATASETONUPDATEERROR_W,'ONUPDATEERROR');
    RegisterEventPropertyHelper(@TIBCUSTOMDATASETONUPDATERECORD_R,@TIBCUSTOMDATASETONUPDATERECORD_W,'ONUPDATERECORD');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBGENERATORFIELD(CL: TIFPSRuntimeClassImporter);
begin
  with CL.Add(TIBGENERATORFIELD) do
  begin
    RegisterConstructor(@TIBGENERATORFIELD.CREATE, 'CREATE');
    RegisterMethod(@TIBGENERATORFIELD.VALUENAME, 'VALUENAME');
    RegisterMethod(@TIBGENERATORFIELD.APPLY, 'APPLY');
    RegisterPropertyHelper(@TIBGENERATORFIELDFIELD_R,@TIBGENERATORFIELDFIELD_W,'FIELD');
    RegisterPropertyHelper(@TIBGENERATORFIELDGENERATOR_R,@TIBGENERATORFIELDGENERATOR_W,'GENERATOR');
    RegisterPropertyHelper(@TIBGENERATORFIELDINCREMENTBY_R,@TIBGENERATORFIELDINCREMENTBY_W,'INCREMENTBY');
    RegisterPropertyHelper(@TIBGENERATORFIELDAPPLYEVENT_R,@TIBGENERATORFIELDAPPLYEVENT_W,'APPLYEVENT');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBDATALINK(CL: TIFPSRuntimeClassImporter);
begin
  with CL.Add(TIBDATALINK) do
  begin
    RegisterConstructor(@TIBDATALINK.CREATE, 'CREATE');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBBCDFIELD(CL: TIFPSRuntimeClassImporter);
begin
  with CL.Add(TIBBCDFIELD) do
  begin
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBSTRINGFIELD(CL: TIFPSRuntimeClassImporter);
begin
  with CL.Add(TIBSTRINGFIELD) do
  begin
    RegisterMethod(@TIBSTRINGFIELD.GETVALUE, 'GETVALUE');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_TIBDATASETUPDATEOBJECT(CL: TIFPSRuntimeClassImporter);
begin
  with CL.Add(TIBDATASETUPDATEOBJECT) do
  begin
    RegisterPropertyHelper(@TIBDATASETUPDATEOBJECTREFRESHSQL_R,@TIBDATASETUPDATEOBJECTREFRESHSQL_W,'REFRESHSQL');
  end;
end;

(*----------------------------------------------------------------------------*)
procedure RIRegister_IBCustomDataSet(CL: TIFPSRuntimeClassImporter);
begin
  with CL.Add(TIBCUSTOMDATASET) do
  with CL.Add(TIBDATASET) do
  RIRegister_TIBDATASETUPDATEOBJECT(CL);
  RIRegister_TIBSTRINGFIELD(CL);
  RIRegister_TIBBCDFIELD(CL);
  RIRegister_TIBDATALINK(CL);
  RIRegister_TIBGENERATORFIELD(CL);
  RIRegister_TIBCUSTOMDATASET(CL);
  RIRegister_TIBDATASET(CL);
end;

 
 
{ TIFPS3CE_IBCustomDataSet }
(*----------------------------------------------------------------------------*)
procedure TIFPS3CE_IBCustomDataSet.CompOnUses(CompExec: TIFPS3CompExec);
begin
  { nothing } 
end;
(*----------------------------------------------------------------------------*)
procedure TIFPS3CE_IBCustomDataSet.ExecOnUses(CompExec: TIFPS3CompExec);
begin
  { nothing } 
end;
(*----------------------------------------------------------------------------*)
procedure TIFPS3CE_IBCustomDataSet.CompileImport1(CompExec: TIFPS3CompExec);
begin
  SIRegister_IBCustomDataSet(CompExec.Comp);
end;
(*----------------------------------------------------------------------------*)
procedure TIFPS3CE_IBCustomDataSet.CompileImport2(CompExec: TIFPS3CompExec);
begin
  { nothing } 
end;
(*----------------------------------------------------------------------------*)
procedure TIFPS3CE_IBCustomDataSet.ExecImport1(CompExec: TIFPS3CompExec; const ri: TIFPSRuntimeClassImporter);
begin
  RIRegister_IBCustomDataSet(ri);
end;
(*----------------------------------------------------------------------------*)
procedure TIFPS3CE_IBCustomDataSet.ExecImport2(CompExec: TIFPS3CompExec; const ri: TIFPSRuntimeClassImporter);
begin
  { nothing } 
end;
 
 
initialization
 (**) 
{$IFDEF USEIMPORTER}
CIImporter.AddCallBack(@SIRegister_IBCustomDataSet,PT_ClassImport);
{$ENDIF}
finalization
 (**) 
 
end.
